/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import java.io.Serializable;

public final class VWGuid
implements Serializable {
    private static final long serialVersionUID = 471L;
    private static final String MIN_GUID_STRING_REPRESENTATION = "00000000000000000000000000000000";
    private static final int GUID_LEN = 16;
    private static final int GUID_STRING_LEN = 32;
    private static final char[] GUID_STRING_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final byte[] GUID_BYTE_ORDER = new byte[]{3, 2, 1, 0, 5, 4, 7, 6, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int HASH_KEY_MASK = Integer.MAX_VALUE;
    private byte[] m_guidBytes = null;
    private int m_hashCode = -1;

    public VWGuid() throws VWException {
        this(MIN_GUID_STRING_REPRESENTATION);
    }

    public VWGuid(String theGuid) throws VWException {
        this.generateBytes(theGuid);
    }

    public VWGuid(byte[] inBytes) throws VWException {
        int arrayLength;
        int n = arrayLength = inBytes == null ? 0 : inBytes.length;
        if (arrayLength != 16) {
            throw new VWException("vw.api.VWGuidInvalidGuidLength", "The GUID instance could not be created. The number of bytes specified is: \"{0}\" bytes. This is an incorrect length. Change the number of bytes to the correct length for a GUID.", arrayLength);
        }
        this.m_guidBytes = new byte[arrayLength];
        System.arraycopy(inBytes, 0, this.m_guidBytes, 0, arrayLength);
        this.generateHashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            try {
                byte[] inBytes = ((VWGuid)obj).getBytes();
                for (int i = 0; i < this.m_guidBytes.length; ++i) {
                    if (inBytes[i] == this.m_guidBytes[i]) continue;
                    return false;
                }
                return true;
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public byte[] getBytes() throws VWException {
        byte[] outBytes = new byte[this.m_guidBytes.length];
        System.arraycopy(this.m_guidBytes, 0, outBytes, 0, this.m_guidBytes.length);
        return outBytes;
    }

    public boolean isUndefined() {
        for (int i = 0; i < this.m_guidBytes.length; ++i) {
            if (this.m_guidBytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("{");
        for (int i = 0; i < 16; ++i) {
            if (i == 4 || i == 6 || i == 8 || i == 10) {
                buffer.append('-');
            }
            byte b = this.m_guidBytes[GUID_BYTE_ORDER[i]];
            buffer.append(GUID_STRING_DIGITS[0xF & b >> 4]);
            buffer.append(GUID_STRING_DIGITS[0xF & b]);
        }
        buffer.append("}");
        return buffer.toString();
    }

    private void generateBytes(String guidString) throws VWException {
        int i;
        if (guidString == null) {
            throw new VWException("vw.api.VWGuidNullGuid", "A byte array for the GUID could not be generated. A null string was passed as the GUID value. Ensure the string is a valid GUID value.");
        }
        char[] charArray = new char[32];
        int index = 0;
        for (i = 0; i < guidString.length(); ++i) {
            char c = guidString.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) continue;
            if (index >= 32) {
                throw new VWException("vw.api.VWGuidTooLong", "A byte array for the GUID could not be generated. The specified GUID string length of \"{0}\" is too long. Ensure the GUID string is a valid length.", guidString);
            }
            charArray[index++] = c;
        }
        if (index != 32) {
            throw new VWException("vw.api.VWGuidTooShort", "A byte array for the GUID could not be generated. The specified GUID string length of \"{0}\" is too short. Ensure the GUID string is a valid length.", guidString);
        }
        this.m_guidBytes = new byte[16];
        index = 0;
        for (i = 0; i < 16; ++i) {
            byte upperByte = (byte)(Character.digit(charArray[index++], 16) << 4);
            byte lowerByte = (byte)Character.digit(charArray[index++], 16);
            this.m_guidBytes[VWGuid.GUID_BYTE_ORDER[i]] = (byte)(upperByte + lowerByte);
        }
        this.generateHashCode();
    }

    private void generateHashCode() {
        int hc = 0;
        int tmp = 0;
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            tmp = 0;
            for (int j = 0; j < 32; j += 8) {
                tmp += (this.m_guidBytes[k] & 0xFF) << j;
                ++k;
            }
            hc += tmp;
        }
        this.m_hashCode = hc & Integer.MAX_VALUE;
    }
}

